<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>电话号码验证</title>
<style>
    @media (max-width: 768px) {
        .container {
            margin: 10px;
            padding: 10px;
        }
        .form-control, .btn {
            padding: 8px;
        }
    }
    body {
        font-family: Arial, sans-serif;
        background-color: #f7f7f7;
        margin: 0;
        padding: 20px;
    }
    .container {
        max-width: 400px;
        margin: 50px auto;
        padding: 20px;
        background-color: #fff;
        border-radius: 5px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }
    .form-control {
        width: 100%;
        padding: 10px;
        margin-bottom: 10px;
        border: 1px solid #ddd;
        border-radius: 4px;
        box-sizing: border-box; /* Make sure padding doesn't affect width */
    }
    .form-control:focus {
        border-color: #0056b3;
        outline: none;
    }
    .btn {
        width: 100%;
        padding: 10px;
        border: none;
        border-radius: 4px;
        background-color: #0056b3;
        color: white;
        cursor: pointer;
        margin-bottom: 10px;
    }
    .btn:hover {
        background-color: #003d82;
    }
    .readonly {
        background-color: #e9ecef;
    }
</style>
<script>
function sendCode() {
    console.log("sendCode function is called."); // 用于调试的日志输出
    var phoneNumber = document.getElementById('phone').value;
    if (!phoneNumber) {
        alert('请输入电话号码！');
        return;
    }
    var xhr = new XMLHttpRequest();
    xhr.open('POST', 'process_phone.php', true);
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    xhr.onreadystatechange = function() {
        if (this.readyState === XMLHttpRequest.DONE) {
            console.log('Response received:', this.responseText);
            if (this.status === 200) {
                try {
                     var response = JSON.parse(this.responseText);
                     alert(response.msg); // 弹出msg信息
                } catch (e) {
                     alert('解析错误：' + e.message);
                }
            } else {
                alert('发生错误：' + this.statusText);
            }
        }
    };
    xhr.send('action=sendCode&phone=' + encodeURIComponent(phoneNumber)); // 添加action字段
}

function verifyCode() {
    var phoneNumber = document.getElementById('phone').value;
    var verifyCode = document.getElementById('verify').value;
    var duration = document.getElementById('duration').value;
    var beizhu = document.getElementById('beizhu').value;
    var xhr = new XMLHttpRequest();
    xhr.open('POST', 'process_phone.php', true);
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    xhr.onreadystatechange = function() {
        if (this.readyState === XMLHttpRequest.DONE) {
            console.log('Response received:', this.responseText);
            if (this.status === 200) {
                try {
                    var response = JSON.parse(this.responseText);
                    alert(response.msg); // 弹出msg信息
                    if (response.success) {
                        document.getElementById('token').value = response.data.token;
                    }
                } catch (e) {
                    alert('解析错误：' + e.message);
                }
            } else {
                alert('发生错误：' + this.statusText);
            }
        }
    };
    xhr.send('action=verify&phone=' + encodeURIComponent(phoneNumber) + '&verify=' + encodeURIComponent(verifyCode) + '&duration=' + encodeURIComponent(duration) + '&beizhu=' + encodeURIComponent(beizhu));
}



</script>
</head>
<body>
    <div class="container">
        <input type="text" id="phone" class="form-control" placeholder="输入电话号码">
        <button onclick="sendCode()" class="btn">发送验证码</button>
        <br>
        <input type="text" id="verify" class="form-control" placeholder="输入验证码">
        <select id="duration" class="form-control">
            <option value="1 month">一个月</option>
            <option value="6 months">半年</option>
            <option value="1 year">一年</option>
            <option value="forever">永久</option>
        </select>
        <input type="text" id="beizhu" class="form-control" placeholder="输入备注">
        <button onclick="verifyCode()" class="btn">确定</button>
        <h2 class="centered-header"><a href="" style="color:#000000">胖乖生活代看广告赚积分！</a></h2>
        <a href="jifen.php" class="btn">查询积分</a><br>
         <h2 ><a href="" style="color:#000000">有问题联系管理员！！！</a></h2>
        <h2 ><el-link type="primary"><a href="" style="color:#000000">温馨提示：<a href="" style="color:#409EFF">app和小程序正常使用</a></h2>
        <br>
    </div>
</body>
</html>