<?php

$servername = "localhost";
$username = "pgsh";
$password = "twDBzcGYTzmykMPp";
$dbname = "pgsh";

function findTokenByPhone($phone) {
    global $servername, $username, $password, $dbname;

    // 创建数据库连接
    $conn = new mysqli($servername, $username, $password, $dbname);
    
    // 检查连接
    if ($conn->connect_error) {
        die("连接失败: " . $conn->connect_error);
    }
    
    // 准备SQL语句，使用预处理语句以避免SQL注入
    $stmt = $conn->prepare("SELECT token, daoqi, zt, t_jf FROM user_tokens WHERE phone = ?");
    $stmt->bind_param("s", $phone);
    
    // 执行查询
    $stmt->execute();
    $result = $stmt->get_result();
    
    // 获取查询结果
    if ($row = $result->fetch_assoc()) {
        $data = [
            'token' => $row['token'],
            'daoqi' => $row['daoqi'],
            't_jf' => $row['t_jf']
        ];
    } else {
        $data = null;
    }
    
    // 关闭语句和连接
    $stmt->close();
    $conn->close();
    
    return $data;
}

function getCoin($token) {
    $baseHeaders = [
        'Authorization: ' . $token,
        'Version: 1.35.0',
        'channel: h5',
        'Content-Type: application/x-www-form-urlencoded;charset=UTF-8',
        'Host: userapi.qiekj.com',
        'Connection: Keep-Alive',
        'Accept-Encoding: gzip',
        'User-Agent: okhttp/3.14.9',
        'Accept: */*'
    ];
    $coinUrl = 'https://userapi.qiekj.com/user/balance';
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $coinUrl);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(['token' => $token]));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $baseHeaders);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_ENCODING, 'gzip');
    
    $response = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    
    if ($err) {
        return "cURL Error #:" . $err;
    } else {
        $result = json_decode($response, true);
        if ($result && $result['code'] === 0 && isset($result['data']['integral'])) {
            return $result['data']['integral'];
        } else {
            return "(需要重新验证)积分查询失败，错误码：" . $result['code'];
        }
    }
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["phone"])) {
    $phone = $_POST["phone"];
    $userData = findTokenByPhone($phone);
    if ($userData) {
        $coin = getCoin($userData['token']);
        $daoqi = $userData['daoqi'];
        $t_jf = $userData['t_jf'];
        
        // 判断到期时间
        $current_time = new DateTime();
        $expiry_time = new DateTime($daoqi);
        $status = ($expiry_time < $current_time) ? "已到期" : "还在有效期内";
        
        // 判断今日积分状态
        $todayStatus = is_null($t_jf) ? "今日积分还没到账" : "今日已获取 " . $t_jf . " 积分";
    } else {
        $coin = "未找到手机号，请返回首页重新提交即可";
        $daoqi = null; // 到期时间为空
        $status = null;
        $todayStatus = null; // 今日积分状态为空
    }
}
?>

<!DOCTYPE html>
<html lang="zh">
<head>
    <meta charset="UTF-8">
    <title>积分查询</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        @media (max-width: 768px) {
            .score-display, form {
                max-width: 100%;
                box-sizing: border-box;
                padding: 15px;
            }
            input[type="text"], button, a {
                width: 100%;
                box-sizing: border-box;
            }
        }
    
        body {
            font-family: "Microsoft YaHei", Arial, sans-serif;
            background-color: #f7f7f7;
            color: #333;
            margin: 0;
            padding: 20px;
        }
        h1 {
            color: #2c3e50;
            text-align: center;
        }
        .score-display {
            max-width: 300px;
            margin: 20px auto;
            padding: 20px;
            background-color: #2ecc71;
            color: white;
            text-align: center;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            font-size: 24px;
            margin-bottom: 0;
        }
        form {
            max-width: 300px;
            margin: 0 auto 20px;
            padding: 20px;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        label {
            display: block;
            margin-bottom: 10px;
        }
        input[type="text"] {
            width: calc(100% - 22px);
            padding: 10px;
            margin-bottom: 20px;
            border: 1px solid #ccc;
            border-radius: 4px;
            box-sizing: border-box;
        }
        button {
            width: 100%;
            padding: 10px;
            background-color: #3498db;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }
        button:hover {
            background-color: #2980b9;
        }
        
        a {
            width: 100%;
            padding: 10px;
            background-color: #3498db;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }
        a:hover {
            background-color: #2980b9;
        }
    </style>
</head>
<body>
    <h1>积分查询</h1>

    <form method="post" action="">
        <label for="phone">手机号码：</label>
        <input type="text" id="phone" name="phone" required>
        <button type="submit">查询积分</button>
         <h2 class=<a href="" style="color:#000000">有问题联系v：<br>rjppg2021</a>
         <h2 class=<a href="" style="color:#000000">胖乖生活代看广告赚积分！</a>
         <h2 class=<a href="" style="color:#000000">不影响正常使用！<br>app和小程序正常用</a></h2> 
        <br><br>
        <?php if (isset($coin)): ?>
        <div>
            <p>总积分为: <?php echo htmlspecialchars($coin); ?></p>
        </div>
        <?php endif; ?>
        
        <?php if (isset($daoqi)): ?>
        <div>
            <p>到期时间为: <?php echo htmlspecialchars($daoqi); ?></p>
        </div>
        <div>
            <p>状态: <?php echo htmlspecialchars($status); ?></p>
        </div>
        <?php endif; ?>
        
        <?php if (isset($todayStatus)): ?>
        <div>
            <p><?php echo htmlspecialchars($todayStatus); ?></p>
        </div>
        <?php endif; ?>
    </form>
</body>
</html>