<?php

$host = 'localhost';
$username = "pgsh";
$password = "twDBzcGYTzmykMPp";
$dbname = "pgsh";

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("数据库连接失败: " . $e->getMessage());
}
$stmt = $pdo->query("SELECT phone, token FROM user_tokens WHERE token IS NOT NULL AND zt = 1");
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
$url = "https://userapi.qiekj.com/integralRecord/pageList";
$headers = [
    'User-Agent: Mozilla/5.0 (Linux; Android 14; 23117RK66C Build/UKQ1.230804.001; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/118.0.0.0 Mobile Safari/537.36 AgentWeb/5.0.0 UCBrowser/11.6.4.950 com.qiekj.QEUser',
    'Accept: application/json, text/plain, */*',
    'channel: android_app'
];
$currentDate = date('Y-m-d');
foreach ($users as $user) {
    $token = $user['token'];
    $phone = $user['phone'];
    $userHeaders = array_merge($headers, [
        'Authorization: ' . $token
    ]);
    $postData = [
        'page' => 1,
        'pageSize' => 100,
        'type' => 100,
        'receivedStatus' => 1,
        'token' => $token
    ];
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $userHeaders);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
    $response = curl_exec($ch);
    curl_close($ch);
    if ($response !== false) {
        $data = json_decode($response, true);
        if (isset($data['data']['items'])) {
            $totalAmount = 0;
            foreach ($data['data']['items'] as $item) {
                $receivedDate = substr($item['receivedTime'], 0, 10);
                if ($receivedDate === $currentDate) {
                    $totalAmount += $item['amount'];
                }
            }
            $updateStmt = $pdo->prepare("UPDATE user_tokens SET t_jf = :t_jf, updated_at = NOW() WHERE phone = :phone");
            $updateStmt->execute([
                't_jf' => $totalAmount,
                'phone' => $phone
            ]);
            echo "手机号: $phone 今日积分: $totalAmount 已更新到数据库.\n";
        } else {
            echo "手机号: $phone 无积分数据.\n";
        }
    } else {
        echo "手机号: $phone 请求失败.\n";
    }
}
?>