<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>卡密续费</title>
<style>
    @media (max-width: 768px) {
        .container {
            margin: 10px;
            padding: 10px;
        }
        .form-control, .btn {
            padding: 8px;
        }
    }
    body {
        font-family: Arial, sans-serif;
        background-color: #f7f7f7;
        margin: 0;
        padding: 20px;
    }
    .container {
        max-width: 400px;
        margin: 50px auto;
        padding: 20px;
        background-color: #fff;
        border-radius: 5px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }
    .form-control {
        width: 100%;
        padding: 10px;
        margin-bottom: 10px;
        border: 1px solid #ddd;
        border-radius: 4px;
        box-sizing: border-box; /* Make sure padding doesn't affect width */
    }
    .form-control:focus {
        border-color: #0056b3;
        outline: none;
    }
    .btn {
        width: 100%;
        padding: 10px;
        border: none;
        border-radius: 4px;
        background-color: #0056b3;
        color: white;
        cursor: pointer;
        margin-bottom: 10px;
    }
    .btn:hover {
        background-color: #003d82;
    }
    .readonly {
        background-color: #e9ecef;
    }
</style>
<script>
function verifyCode() {
    var phoneNumber = document.getElementById('phone').value;
    var cardKey = document.getElementById('cardKey').value;
    var xhr = new XMLHttpRequest();
    xhr.open('POST', 'process_phone.php', true);
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    xhr.onreadystatechange = function() {
        if (this.readyState === XMLHttpRequest.DONE) {
            console.log('Response received:', this.responseText);
            if (this.status === 200) {
                try {
                    var response = JSON.parse(this.responseText);
                    alert(response.msg); // 弹出msg信息
                    if (response.success) {
                        // Handle success if necessary
                    }
                } catch (e) {
                    alert('解析错误：' + e.message);
                }
            } else {
                alert('发生错误：' + this.statusText);
            }
        }
    };
    xhr.send('action=verify&phone=' + encodeURIComponent(phoneNumber) + '&cardKey=' + encodeURIComponent(cardKey));
}
</script>
</head>
<body>
    <div class="container">
        <input type="text" id="phone" class="form-control" placeholder="输入电话号码">
        <input type="text" id="cardKey" class="form-control" placeholder="输入卡密">
        <button onclick="verifyCode()" class="btn">确定</button>
        <br><br>
        <hr>
        <p>续费成功之后需要等几分钟再去查询，如果查询还是"积分查询失败"的话联系商家</p>
    </div>
</body>
</html>
