<?php
header('Content-Type: application/json');

header('X-Content-Type-Options: nosniff');
header('X-XSS-Protection: 1; mode=block');
header('Content-Security-Policy: default-src \'self\'; script-src \'self\';');

$dbHost = 'localhost';
$dbUser = 'pgsh';
$dbPass = 'twDBzcGYTzmykMPp';
$dbName = 'pgsh';

$mysqli = new mysqli($dbHost, $dbUser, $dbPass, $dbName);
$mysqli->set_charset('utf8mb4');

if ($mysqli->connect_error) {
    die(json_encode(array('msg' => '数据库连接失败', 'success' => false)));
}

if (isset($_POST['phone']) && isset($_POST['cardKey'])) {
    $phone = htmlspecialchars($mysqli->real_escape_string($_POST['phone']));
    $cardKey = htmlspecialchars($mysqli->real_escape_string($_POST['cardKey']));

    $stmt = $mysqli->prepare("SELECT duration FROM card_keys WHERE card_key = ? AND zt = 0");
    if (!$stmt) {
        echo json_encode(array('msg' => '查询卡密时发生错误: ' . $mysqli->error, 'success' => false));
        $mysqli->close();
        exit;
    }
    $stmt->bind_param("s", $cardKey);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $duration = $row['duration'];
    } else {
        echo json_encode(array('msg' => '无效的卡密', 'success' => false));
        $mysqli->close();
        exit;
    }

    $stmt = $mysqli->prepare("SELECT daoqi FROM user_tokens WHERE phone = ?");
    if (!$stmt) {
        echo json_encode(array('msg' => '查询电话号码时发生错误: ' . $mysqli->error, 'success' => false));
        $mysqli->close();
        exit;
    }
    $stmt->bind_param("s", $phone);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        $userRow = $result->fetch_assoc();
        $daoqi = new DateTime($userRow['daoqi']);
        $now = new DateTime(); // 当前时间

        // 如果daoqi已经过期，或者当前时间等于daoqi，从当前时间开始计算新的到期时间
        if ($daoqi <= $now) {
            $currentDate = $now;
        } else {
            // 如果daoqi未过期，从daoqi开始计算新的到期时间
            $currentDate = $daoqi;
        }
    } else {
        echo json_encode(array('msg' => '电话号码不存在', 'success' => false));
        $mysqli->close();
        exit;
    }

    // 根据卡密的时长计算新的到期时间
    if (preg_match('/^(\d+) months$/', $duration, $matches)) {
        $interval = 'P' . $matches[1] . 'M';
    } else {
        switch ($duration) {
            case '1 month':
                $interval = 'P1M';
                break;
            case '6 months':
                $interval = 'P6M';
                break;
            case '1 year':
                $interval = 'P1Y';
                break;
            case 'forever':
                $interval = 'P100Y';
                break;
            default:
                $interval = 'P1M';
                break;
        }
    }
    $currentDate->add(new DateInterval($interval));
    $newDaoqi = $currentDate->format('Y-m-d H:i:s');

    $stmt = $mysqli->prepare("UPDATE user_tokens SET daoqi = ? WHERE phone = ?");
    if (!$stmt) {
        echo json_encode(array('msg' => '更新用户到期时间时发生错误: ' . $mysqli->error, 'success' => false));
        $mysqli->close();
        exit;
    }
    $stmt->bind_param("ss", $newDaoqi, $phone);
    $stmt->execute();

    $stmt = $mysqli->prepare("UPDATE card_keys SET zt = 1, user = ? WHERE card_key = ?");
    if (!$stmt) {
        echo json_encode(array('msg' => '更新卡密状态时发生错误: ' . $mysqli->error, 'success' => false));
        $mysqli->close();
        exit;
    }
    $stmt->bind_param("ss", $phone, $cardKey);
    $stmt->execute();

    echo json_encode(array('msg' => '续费成功', 'success' => true, 'newDaoqi' => $newDaoqi));
} else {
    echo json_encode(array('msg' => '电话号码或卡密未提供', 'success' => false));
}

$mysqli->close();
?>
