<?php
header('Content-Type: application/json'); // 设置响应头为JSON


$dbHost = 'localhost'; 
$dbUser = 'pgsh'; 
$dbPass = 'twDBzcGYTzmykMPp'; 
$dbName = 'pgsh'; 


$mysqli = new mysqli($dbHost, $dbUser, $dbPass, $dbName);

if ($mysqli->connect_error) {
    die('数据库连接失败：' . $mysqli->connect_error);
}

// 检查是否有电话号码以及行为类型传入
if (isset($_POST['phone']) && isset($_POST['action'])) {
    $phone = $_POST['phone'];
    $action = $_POST['action'];

    if ($action == 'sendCode') {
        // 发送验证码的逻辑
        $url = "https://userapi.qiekj.com/common/sms/sendCode";
        $postFields = array(
            'phone' => $phone,
            'template' => 'reg'
        );
    } elseif ($action == 'verify' && isset($_POST['verify']) && isset($_POST['duration'])) {
        // 验证验证码并计算到期日期的逻辑
        $verify = $_POST['verify'];
        $duration = $_POST['duration'];
        $beizhu = $_POST['beizhu'];
        
        // 根据所选择的有效期限计算到期日期
        $currentDate = new DateTime(); // 当前日期
        switch ($duration) {
            case '1 month':
                $interval = 'P1M';
                break;
            case '6 months':
                $interval = 'P6M';
                break;
            case '1 year':
                $interval = 'P1Y';
                break;
            case 'forever':
                $interval = 'P100Y'; 
                break;
            default:
                $interval = 'P1M'; // 默认为1个月
                break;
        }
        $currentDate->add(new DateInterval($interval));
        $daoqi = $currentDate->format('Y-m-d H:i:s'); // 到期时间

        $url = "https://userapi.qiekj.com/user/reg";
        $postFields = array(
            'phone' => $phone,
            'verify' => $verify,
            'channel' => 'h5'
        );
    } else {
        echo json_encode(array('msg' => '无效的行为类型', 'success' => false));
        $mysqli->close();
        exit;
    }

    // 共同的cURL请求处理
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => http_build_query($postFields),
        CURLOPT_HTTPHEADER => array(
            "content-type: application/x-www-form-urlencoded",
        ),
    ));

    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    if ($err) {
        echo json_encode(array('msg' => "cURL Error #:" . $err, 'success' => false));
    } else {
        $responseData = json_decode($response, true);


if ($action == 'verify' && isset($responseData['data']['token'])) {
    $token = $responseData['data']['token'];

    // 检查手机号是否已存在于数据库中
    $stmt = $mysqli->prepare("SELECT * FROM user_tokens WHERE phone = ?");
    $stmt->bind_param("s", $phone);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        // 如果手机号已存在，更新token
        $stmt = $mysqli->prepare("UPDATE user_tokens SET token = ?, daoqi = ?, beizhu = ? WHERE phone = ?");
        $stmt->bind_param("ssss", $token, $daoqi, $beizhu, $phone);
        
    } else {
        // 如果手机号不存在，插入新纪录
        $stmt = $mysqli->prepare("INSERT INTO user_tokens (phone, token, daoqi, beizhu) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("ssss", $phone, $token, $daoqi, $beizhu);
    }
    $stmt->execute();
    $stmt->close();
}
        
        echo $response; // 直接返回API的JSON响应
    }
} else {
    echo json_encode(array('msg' => '电话号码或行为类型未提供', 'success' => false));
}

// 关闭数据库连接
$mysqli->close();
?>
