<?php
include_once 'db_connection.php'; // 包含数据库连接

// 获取表单数据
$export_duration = $_POST['export_duration'];
$export_status = $_POST['export_status'];
$export_format = $_POST['export_format'];

// 构建查询条件
$whereClauses = [];
if ($export_duration != 'all') {
    $whereClauses[] = "duration = '$export_duration'";
}
if ($export_status != 'all') {
    $status = $export_status == 'used' ? 1 : 0;
    $whereClauses[] = "zt = $status";
}
$whereSQL = '';
if (!empty($whereClauses)) {
    $whereSQL = 'WHERE ' . implode(' AND ', $whereClauses);
}

// 查询数据库
$sql = "SELECT * FROM card_keys $whereSQL";
$result = $conn->query($sql);

// 创建文件
if ($export_format == 'csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment;filename=card_keys.csv');

    $output = fopen('php://output', 'w');
    fputcsv($output, array('卡密', '时长', '是否已使用', '使用账号', '生成时间'));

    while ($row = $result->fetch_assoc()) {
        fputcsv($output, array($row['card_key'], $row['duration'], $row['zt'] == 1 ? '已使用' : '未使用', $row['user'], $row['created_at']));
    }

    fclose($output);
} else if ($export_format == 'txt') {
    header('Content-Type: text/plain');
    header('Content-Disposition: attachment;filename=card_keys.txt');

    $output = fopen('php://output', 'w');

    while ($row = $result->fetch_assoc()) {
        fwrite($output, $row['card_key'] . PHP_EOL);
    }

    fclose($output);
}

$conn->close();
exit();
?>
