<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>卡密系统</title>
<style>
    body {
        font-family: Arial, sans-serif;
        padding: 20px;
        margin: 0;
        background-color: #f4f4f4;
    }
    h2 {
        color: #333;
    }
    form {
        background-color: #fff;
        padding: 20px;
        border-radius: 5px;
        box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    label {
        margin-top: 10px;
        display: block;
        color: #666;
    }
    select, input {
        width: 100%;
        padding: 10px;
        margin-top: 5px;
        border-radius: 5px;
        border: 1px solid #ddd;
        box-sizing: border-box; /* Added for better input sizing */
    }
    button {
        background-color: #5cb85c;
        color: white;
        padding: 10px 20px;
        border: none;
        border-radius: 5px;
        cursor: pointer;
        margin-top: 10px;
    }
    button:hover {
        background-color: #4cae4c;
    }
    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
        background-color: #fff;
    }
    th, td {
        text-align: left;
        padding: 8px;
        border: 1px solid #ddd;
    }
    th {
        background-color: #4CAF50;
        color: white;
    }
    @media (max-width: 600px) {
        form, table {
            width: 100%;
        }
    }
    #generated-keys {
        margin-top: 20px;
        background-color: #fff;
        padding: 20px;
        border-radius: 5px;
        box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    #generated-keys textarea {
        width: 100%;
        height: 150px;
        border: 1px solid #ddd;
        border-radius: 5px;
        padding: 10px;
        box-sizing: border-box;
    }
    .action-buttons {
        margin-top: 10px;
    }
</style>
</head>
<body>
    <h2>生成卡密</h2>
    <form id="generate-form">
        <label for="duration">时长:</label>
        <select name="duration" id="duration" onchange="toggleCustomDuration()">
            <option value="1 month">一个月</option>
            <option value="6 months">半年</option>
            <option value="1 year">一年</option>
            <option value="forever">永久</option>
            <option value="custom">自定义</option>
        </select>
        <div id="custom-duration-container" style="display: none;">
            <label for="custom-duration">自定义月数:</label>
            <input type="number" id="custom-duration" name="custom-duration" min="1">
        </div>
        <label for="quantity">数量:</label>
        <input type="number" id="quantity" name="quantity" min="1" max="100">
        <button type="submit">生成卡密</button>
    </form>

    <div id="generated-keys" style="display: none;">
        <h2>生成的卡密</h2>
        <textarea id="card-keys" readonly></textarea>
        <div class="action-buttons">
            <button onclick="copyToClipboard()">复制</button>
            <button onclick="saveAsTxt()">保存为TXT文件</button>
        </div>
    </div>
    
    <h2>导出卡密</h2>
    <form action="export_keys.php" method="post">
        <label for="export_duration">时长:</label>
        <select name="export_duration" id="export_duration">
            <option value="all">所有</option>
            <option value="1 month">一个月</option>
            <option value="6 months">半年</option>
            <option value="1 year">一年</option>
            <option value="forever">永久</option>
        </select>
        <label for="export_status">状态:</label>
        <select name="export_status" id="export_status">
            <option value="all">所有</option>
            <option value="used">已使用</option>
            <option value="unused">未使用</option>
        </select>
        <label for="export_format">格式:</label>
        <select name="export_format" id="export_format">
            <option value="csv">CSV</option>
            <option value="txt">TXT</option>
        </select>
        <button type="submit">导出卡密</button>
    </form>
    
    <h2>卡密列表</h2>
    <table border="1">
        <tr>
            <th>卡密</th>
            <th>时长</th>
            <th>是否已使用</th>
            <th>使用账号</th>
            <th>生成时间</th>
        </tr>
        <?php include 'generate_keys.php'; ?>
        <?php while($row = $cardKeys->fetch_assoc()): ?>
        <tr>
            <td><?php echo $row['card_key']; ?></td>
            <td><?php echo $row['duration']; ?></td>
            <td><?php echo $row['zt'] == 1 ? '已使用' : '未使用'; ?></td>
            <td><?php echo $row['user']; ?></td>
            <td><?php echo $row['created_at']; ?></td>
        </tr>
        <?php endwhile; ?>
    </table>

    <script>
        function toggleCustomDuration() {
            const durationSelect = document.getElementById('duration');
            const customDurationContainer = document.getElementById('custom-duration-container');
            if (durationSelect.value === 'custom') {
                customDurationContainer.style.display = 'block';
            } else {
                customDurationContainer.style.display = 'none';
            }
        }

        document.getElementById('generate-form').addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(this);
            const durationSelect = document.getElementById('duration');
            if (durationSelect.value === 'custom') {
                const customDuration = document.getElementById('custom-duration').value;
                formData.set('duration', customDuration + ' months');
            }
            fetch('generate_keys.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    const cardKeys = data.cardKeys.join('\n');
                    document.getElementById('card-keys').value = cardKeys;
                    document.getElementById('generated-keys').style.display = 'block';
                } else {
                    alert('生成卡密失败');
                }
            });
        });

        function copyToClipboard() {
            const textarea = document.getElementById('card-keys');
            textarea.select();
            document.execCommand('copy');
            alert('卡密已复制到剪贴板');
        }

        function saveAsTxt() {
            const cardKeys = document.getElementById('card-keys').value;
            const blob = new Blob([cardKeys], { type: 'text/plain' });
            const link = document.createElement('a');
            link.href = URL.createObjectURL(blob);
            link.download = 'generated_card_keys.txt';
            link.click();
        }
    </script>
</body>
</html>
