<?php
header('Content-Type: application/json'); // 设置响应头为JSON
header('X-Content-Type-Options: nosniff'); // 防止MIME类型混淆攻击
header('X-XSS-Protection: 1; mode=block'); // 启用XSS保护
header('Content-Security-Policy: default-src \'self\'; script-src \'self\';'); // 设置内容安全策略

// 数据库配置
$dbHost = 'localhost'; 
$dbUser = 'pgsh'; 
$dbPass = 'twDBzcGYTzmykMPp'; 
$dbName = 'pgsh'; 

// 连接数据库
$mysqli = new mysqli($dbHost, $dbUser, $dbPass, $dbName);
$mysqli->set_charset('utf8mb4');

if ($mysqli->connect_error) {
    die(json_encode(array('msg' => '数据库连接失败', 'success' => false)));
}

// 检查是否有电话号码以及行为类型传入
if (isset($_POST['phone']) && isset($_POST['action'])) {
    $phone = htmlspecialchars($mysqli->real_escape_string($_POST['phone']));
    $action = htmlspecialchars($mysqli->real_escape_string($_POST['action']));

    // 确保电话号码符合预期格式
    if (!preg_match('/^\d{10,15}$/', $phone)) {
        echo json_encode(array('msg' => '无效的电话号码', 'success' => false));
        $mysqli->close();
        exit;
    }

    // 查询电话号码是否已存在并且zt是否为1
    $stmt = $mysqli->prepare("SELECT zt, daoqi FROM user_tokens WHERE phone = ?");
    $stmt->bind_param("s", $phone);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        $userRow = $result->fetch_assoc();
        if ($userRow['zt'] == 1) {
            echo json_encode(array('msg' => '当前账号还在有效期无需重新验证，或者等待两分钟重新验证', 'success' => false));
            $mysqli->close();
            exit;
        }

        // 检查到期日期
        $currentDate = new DateTime(); // 当前日期
        $expiryDate = new DateTime($userRow['daoqi']); // 数据库中的到期日期

        if ($currentDate > $expiryDate) {
            echo json_encode(array('msg' => '您的号码已到期，请续费', 'success' => false));
            $mysqli->close();
            exit;
        }
    } else {
        echo json_encode(array('msg' => '号码不存在', 'success' => false));
        $mysqli->close();
        exit;
    }

    if ($action == 'sendCode') {
        // 发送验证码的逻辑
        $url = "https://userapi.qiekj.com/common/sms/sendCode";
        $postFields = array(
            'phone' => $phone,
            'template' => 'reg'
        );
    } elseif ($action == 'verify' && isset($_POST['verify'])) {
        // 验证验证码并检查到期日期的逻辑
        $verify = htmlspecialchars($mysqli->real_escape_string($_POST['verify']));
        $beizhu = htmlspecialchars($mysqli->real_escape_string($_POST['beizhu']));

        $url = "https://userapi.qiekj.com/user/reg";
        $postFields = array(
            'phone' => $phone,
            'verify' => $verify,
            'channel' => 'h5'
        );
    } else {
        echo json_encode(array('msg' => '无效的行为类型', 'success' => false));
        $mysqli->close();
        exit;
    }

    // 共同的cURL请求处理
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => http_build_query($postFields),
        CURLOPT_HTTPHEADER => array(
            "content-type: application/x-www-form-urlencoded",
        ),
    ));

    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    if ($err) {
        echo json_encode(array('msg' => "cURL Error #:" . $err, 'success' => false));
    } else {
        $responseData = json_decode($response, true);

        // 如果是验证行为，即action为验证，并且API的响应中有token
        if ($action == 'verify' && isset($responseData['data']['token'])) {
            $token = $responseData['data']['token'];

            // 检查手机号是否已存在于数据库中
            $stmt = $mysqli->prepare("SELECT * FROM user_tokens WHERE phone = ?");
            $stmt->bind_param("s", $phone);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows > 0) {
                // 如果手机号已存在，更新token
                $stmt = $mysqli->prepare("UPDATE user_tokens SET token = ?, beizhu = ? WHERE phone = ?");
                $stmt->bind_param("sss", $token, $beizhu, $phone);
            } 
            $stmt->execute();
            $stmt->close();
        }
        
        echo $response; // 直接返回API的JSON响应
    }
} else {
    echo json_encode(array('msg' => '电话号码或行为类型未提供', 'success' => false));
}

// 关闭数据库连接
$mysqli->close();
?>
