<?php

function getCoin($token) {
    $baseHeaders = [
        'Authorization: ' . $token,
        'Version: 1.35.0',
        'channel: h5',
        'Content-Type: application/x-www-form-urlencoded;charset=UTF-8',
        'Host: userapi.qiekj.com',
        'Connection: Keep-Alive',
        'Accept-Encoding: gzip',
        'User-Agent: okhttp/3.14.9',
        'Accept: */*'
    ];
    $coinUrl = 'https://userapi.qiekj.com/user/balance';
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $coinUrl);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(['token' => $token]));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $baseHeaders);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_ENCODING, 'gzip');
    
    $response = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    
    if ($err) {
        return "cURL错误：" . $err;
    } else {
        $result = json_decode($response, true);
        if ($result && $result['code'] === 0 && isset($result['data']['integral'])) {
            return $result['data']['integral'];
        } else {
            return "积分查询失败，错误码：" . $result['code'];
        }
    }
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["token"])) {
    $token = $_POST["token"];
    $coin = getCoin($token);
}
?>

<!DOCTYPE html>
<html lang="zh">
<head>
    <meta charset="UTF-8">
    <title>积分查询</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        @media (max-width: 768px) {
            .score-display, form {
                max-width: 100%;
                box-sizing: border-box;
                padding: 15px;
            }
            input[type="text"], button, a {
                width: 100%;
                box-sizing: border-box;
            }
        }
    
        body {
            font-family: "Microsoft YaHei", Arial, sans-serif;
            background-color: #f7f7f7;
            color: #333;
            margin: 0;
            padding: 20px;
        }
        h1 {
            color: #2c3e50;
            text-align: center;
        }
        .score-display {
            max-width: 300px;
            margin: 20px auto;
            padding: 20px;
            background-color: #2ecc71;
            color: white;
            text-align: center;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            font-size: 24px;
            margin-bottom: 0;
        }
        form {
            max-width: 300px;
            margin: 0 auto 20px;
            padding: 20px;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        label {
            display: block;
            margin-bottom: 10px;
        }
        input[type="text"] {
            width: calc(100% - 22px);
            padding: 10px;
            margin-bottom: 20px;
            border: 1px solid #ccc;
            border-radius: 4px;
            box-sizing: border-box;
        }
        button {
            width: 100%;
            padding: 10px;
            background-color: #3498db;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }
        button:hover {
            background-color: #2980b9;
        }
        
        a {
            width: 100%;
            padding: 10px;
            background-color: #3498db;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }
        a:hover {
            background-color: #2980b9;
        }
    </style>
</head>
<body>
    <h1>积分查询</h1>

    <form method="post" action="">
        <label for="token">Token：</label>
        <input type="text" id="token" name="token" required>
        <button type="submit">查询积分</button>
        <br><br>
        <?php if (isset($coin)): ?>
            <p>总积分为: <?php echo htmlspecialchars($coin); ?></p>
        <?php endif; ?>
    </form>
</body>
</html>