<?php

$dbHost = 'localhost';
$dbUsername = 'pgsh';
$dbPassword = 'twDBzcGYTzmykMPp';
$dbName = 'pgsh';

$conn = new mysqli($dbHost, $dbUsername, $dbPassword, $dbName);

if ($conn->connect_error) {
    die("连接失败: ". $conn->connect_error);
}

$sql = "SELECT id, token, phone FROM user_tokens";
$result = $conn->query($sql);

// 并发模式开关和并发数量
$enableConcurrency = true; // 设置为 true 开启并发模式
$concurrentLimit = 5; // 设置并发数量

if ($enableConcurrency) {
    // 使用线程池进行并发处理
    $pool = new Pool($concurrentLimit);

    while ($row = $result->fetch_assoc()) {
        $token = $row['token'];
        $id = $row['id'];
        $phone = $row['phone'];

        $pool->submit(function ($token, $id, $phone) use ($conn) {
            // 检查 token 有效性
            $isValid = checkTokenValidity($token);
            $xiao = $isValid? "token 有效" : "token 已失效";
            $ztValue = $isValid? 1 : 0;

            // 更新 user_tokens 表中的 xiao 字段
            $updateSql = "UPDATE user_tokens SET xiao = '$xiao', zt = '$ztValue' WHERE id = '$id'";
            if ($conn->query($updateSql)!== TRUE) {
                echo "更新记录时出错: ". $conn->error;
            }

            // 如果 token 有效，则获取积分
            if ($isValid) {
                $coin = getCoin($token);
                if (is_numeric($coin)) {
                    updateCoin($phone, $coin);
                } else {
                    // 积分查询失败，更新数据库的 jifen 字段为“token 失效”
                    updateCoinStatus($phone, "token 失效");
                }
            }
            sleep(0.5);
        }, $token, $id, $phone);
    }

    $pool->shutdown();
} else {
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $token = $row['token'];
            $id = $row['id'];
            $phone = $row['phone'];

            // 检查 token 有效性
            $isValid = checkTokenValidity($token);
            $xiao = $isValid? "token 有效" : "token 已失效";
            $ztValue = $isValid? 1 : 0;

            // 更新 user_tokens 表中的 xiao 字段
            $updateSql = "UPDATE user_tokens SET xiao = '$xiao', zt = '$ztValue' WHERE id = '$id'";
            if ($conn->query($updateSql)!== TRUE) {
                echo "更新记录时出错: ". $conn->error;
            }

            // 如果 token 有效，则获取积分
            if ($isValid) {
                $coin = getCoin($token);
                if (is_numeric($coin)) {
                    updateCoin($phone, $coin);
                } else {
                    // 积分查询失败，更新数据库的 jifen 字段为“token 失效”
                    updateCoinStatus($phone, "token 失效");
                }
            }
            sleep(0.5);
        }
    } else {
        echo "0 结果";
    }
}

// 关闭数据库连接
$conn->close();

// 检查 token 有效性的函数
function checkTokenValidity($token) {
    $phonUrl = 'https://userapi.qiekj.com/user/info';
    $baseHeaders = [
        'Authorization: '. $token,
        'Version: 1.35.0',
        'channel: h5',
        'Content-Type: application/x-www-form-urlencoded;charset=UTF-8',
        'Host: userapi.qiekj.com',
        'Connection: Keep-Alive',
        'Accept-Encoding: gzip',
        'User-Agent: okhttp/3.14.9',
        'Accept: */*'
    ];

    $postData = http_build_query(['token' => $token]);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $phonUrl);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $baseHeaders);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_ENCODING, 'gzip');

    $response = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);

    if ($err) {
        echo "cURL 错误: ". $err;
        return false;
    } else {
        $data = json_decode($response, true);
        if ($data && $data['code'] === 0) {
            // Token 有效
            return true;
        } else {
            // Token 无效或请求失败
            return false;
        }
    }
}

// 更新积分的函数
function updateCoin($phone, $jifen) {
    global $conn;

    $stmt = $conn->prepare("UPDATE user_tokens SET jifen =? WHERE phone =?");
    $stmt->bind_param("is", $jifen, $phone);

    $stmt->execute();
    $stmt->close();
}

// 更新积分状态的函数
function updateCoinStatus($phone, $status) {
    global $conn;

    $stmt = $conn->prepare("UPDATE user_tokens SET jifen =? WHERE phone =?");
    $stmt->bind_param("ss", $status, $phone);

    $stmt->execute();
    $stmt->close();
}

// 获取积分的函数
function getCoin($token) {
    $coinUrl = 'https://userapi.qiekj.com/user/balance';
    $baseHeaders = [
        'Authorization: '. $token,
        'Version: 1.35.0',
        'channel: h5',
        'Content-Type: application/x-www-form-urlencoded;charset=UTF-8',
        'Host: userapi.qiekj.com',
        'Connection: Keep-Alive',
        'Accept-Encoding: gzip',
        'User-Agent: okhttp/3.14.9',
        'Accept: */*'
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $coinUrl);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(['token' => $token]));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $baseHeaders);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_ENCODING, 'gzip');

    $response = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);

    if ($err) {
        return "cURL Error #: ". $err;
    } else {
        $result = json_decode($response, true);
        if ($result && $result['code'] === 0 && isset($result['data']['integral'])) {
            return $result['data']['integral'];
        } else {
            // 积分查询失败
            return false;
        }
    }
}

class Pool
{
    private $workers;
    private $queue;

    public function __construct($size)
    {
        $this->workers = [];
        $this->queue = new SplQueue();

        for ($i = 0; $i < $size; $i++) {
            $this->workers[] = new Worker($this);
        }
    }

    public function submit(callable $task,...$args)
    {
        $this->queue->enqueue([$task, $args]);
        $this->notify();
    }

    public function notify()
    {
        foreach ($this->workers as $worker) {
            if ($worker->isIdle() &&!$this->queue->isEmpty()) {
                $worker->startTask($this->queue->dequeue());
            }
        }
    }

    public function shutdown()
    {
        foreach ($this->workers as $worker) {
            $worker->shutdown();
        }
    }
}

class Worker
{
    private $pool;
    private $task;
    private $args;
    private $running;

    public function __construct(Pool $pool)
    {
        $this->pool = $pool;
        $this->running = false;
    }

    public function isIdle()
    {
        return!$this->running;
    }

    public function startTask($taskData)
    {
        list($this->task, $this->args) = $taskData;
        $this->running = true;
        call_user_func_array($this->task, $this->args);
        $this->running = false;
        $this->pool->notify();
    }

    public function shutdown()
    {
        $this->running = false;
    }
}
?>