<!DOCTYPE html>
<html lang="zh">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>更新用户信息</title>
<style>
    body {
        font-family: 'Arial', sans-serif;
        background-color: #f4f4f4;
        margin: 0;
        padding: 0;
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100vh;
    }
    .form-container {
        background-color: #ffffff;
        padding: 20px;
        border-radius: 5px;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        width: 100%;
        max-width: 400px;
    }
    h2 {
        text-align: center;
        color: #333;
    }
    label {
        display: block;
        margin-top: 10px;
        color: #666;
    }
    input[type="text"],
    select,
    textarea {
        width: 100%;
        padding: 10px;
        margin-top: 5px;
        border: 1px solid #dddddd;
        border-radius: 4px;
        box-sizing: border-box;
    }
    input[type="submit"] {
        background-color: #5cb85c;
        color: white;
        padding: 10px 15px;
        border: none;
        border-radius: 4px;
        cursor: pointer;
        margin-top: 20px;
        width: 100%;
    }
    input[type="submit"]:hover {
        background-color: #4cae4c;
    }
</style>
</head>
<body>
<div class="form-container">
    <h2>更新用户信息</h2>
    <form action="xiugai_chuli.php" method="POST">
        <label for="phone">手机号码:</label>
        <input type="text" id="phone" name="phone" required />
        
        <label for="token">Token (留空则不更新):</label>
        <input type="text" id="token" name="token" />
        
        <label for="duration">有效期 (如果更改，请选择):</label>
        <select id="duration" name="duration">
            <option value="">请选择...</option>
            <option value="1">一个月</option>
            <option value="6">半年</option>
            <option value="12">一年</option>
            <option value="1200">永久</option>
        </select>
        
        <label for="beizhu">备注 (留空则不更新):</label>
        <textarea id="beizhu" name="beizhu"></textarea>
        
        <input type="submit" value="更新信息" />
    </form>
</div>
</body>
</html>
