<!DOCTYPE html>
<html>
<head>
    <title>文件下载</title>
    <style>
          body {
    background-image: url('img/3.png');
    background-size: contain; /* 将背景图片调整为包含在容器内 */
    background-position: center; /* 将背景图片居中 */
    margin: 0;
    padding: 0;
}

        .container {
            width: 50%;
            margin: 20px auto;
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h2 {
            text-align: center;
            margin-bottom: 20px;
        }
        ul {
            list-style-type: none;
            padding: 0;
            margin: 0;
        }
        li {
            margin-bottom: 10px;
        }
        a {
            display: block;
            background-color: #4CAF50;
            color: white;
            padding: 10px;
            text-decoration: none;
            border-radius: 4px;
        }
        a:hover {
            background-color: #45a049;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>文件列表</h2>
        <?php
        $uploadDir = 'up/';
        
        // 检查上传目录是否存在
        if (file_exists($uploadDir)) {
            // 打开上传目录
            $dir = opendir($uploadDir);

            // 输出文件列表
            echo "<ul>";
            while (($file = readdir($dir)) !== false) {
                // 忽略当前目录和父目录
                if ($file != '.' && $file != '..') {
                    echo "<li><a href='up/$file'>$file</a></li>";
                }
            }
            echo "</ul>";

            // 关闭目录
            closedir($dir);
        } else {
            echo "<p>目录不存在。</p>";
        }
        ?>
    </div>
</body>
</html>
