<!DOCTYPE html>
<html>
<head>
    <title>文件上传</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-image: url('img/3.png'); /* 设置页面背景图片 */
            background-size: cover; /* 确保背景图片覆盖整个页面 */
            background-position: center; /* 将背景图片居中 */
            margin: 0;
            padding: 0;
        }
        .container {
            width: 50%;
            margin: 50px auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            text-align: center;
        }
        h2 {
            margin-bottom: 20px;
        }
        p {
            margin-bottom: 20px;
            color: #4CAF50;
        }
        input[type="file"] {
            margin-bottom: 20px;
        }
        input[type="submit"] {
            background-color: #4CAF50;
            border: none;
            color: white;
            padding: 10px 20px;
            text-decoration: none;
            margin: 4px 2px;
            cursor: pointer;
            border-radius: 4px;
        }
        input[type="submit"]:hover {
            background-color: #45a049;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>上传文件</h2>
        <?php if(isset($message)) { ?>
            <p><?php echo $message; ?></p>
        <?php } ?>
        <form enctype="multipart/form-data" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="POST">
            <input type="file" name="file"><br>
            <input type="submit" value="上传文件">
        </form>
        <p>上传成功后会自动回到主页面</p>
    </div>
</body>
</html>
